﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.SchoolYear
{
    public partial class UCSchoolYearDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.SchoolYear, BL.BO.SchoolYear.Search>
    {
        private const int _IndexTabExerciseAvatar = 0;
        protected     int _IndexTabSystemInformation        = 1;

        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabSchoolYearDetails _tabSchoolYearDetails = null;

        public UCTabSchoolYearDetails TabSchoolYearDetails
        {
            get
            {
                if (_tabSchoolYearDetails == null)
                {
                    _tabSchoolYearDetails = new UCTabSchoolYearDetails();
                }
                return _tabSchoolYearDetails;
            }
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCSchoolYearDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabExerciseAvatar, TabSchoolYearDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabSchoolYearDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();


            TabSchoolYearDetails.Save();
            _methodResult = BLZSBELearning.SchoolYear.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.SchoolYear _SchoolYear = BLZSBELearning.SchoolYear.Restore(ID);
            if (_SchoolYear != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _SchoolYear);
                TabSchoolYearDetails.Restore();

                this.CreateToolbarActions();
                Environment.MainWindow.UpdateToolbarMenu(this);
            }

            return _result;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            if (DataManager.Current != null)
            {
                List<BL.BO.Student> _listStudent = BLZSBELearning.Student.Restore(DataManager.Current);
                List<BL.BO.Class> _listClass = BLZSBELearning.Class.Restore(DataManager.Current);

                ProcessStart(ProcessingType.Remove, _listStudent.Count + _listClass.Count  + 1);

                foreach (BL.BO.Student _loopStudent in _listStudent)
                {
                    _methodResult.Add(BLZSBELearning.Student.Remove(_loopStudent));
                    Process();
                }

                foreach (BL.BO.Class _loopClass in _listClass)
                {
                    _methodResult.Add(BLZSBELearning.Class.Remove(_loopClass));
                    Process();
                }

                if (_methodResult.Success == true)
                {
                    _methodResult.Add(BLZSBELearning.SchoolYear.Remove(DataManager.Current));
                }

                Process();
            }
            return _methodResult;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;

            if (DataManager.Current != null)
            {
                if (DataManager.Current.IsActive == true)
                {
                    DispalyMessage(BL.Dictionary.Text.SchoolYear.DeleteForbidden.Value);
                    _return = false;
                }
                else
                {
                    FRemoveSchoolYear _dialog = Gemini.Core.WinForms.Base.Form.Create<FRemoveSchoolYear>(this.Plugin, Environment);
                    _dialog.Initialize(DataManager.Current, Plugin, Environment);

                    if (DialogResult.OK == _dialog.ShowDialog())
                    {
                        _return = true;
                    }
                    else
                    {
                        _return = false;
                    }
                }
            }
            return _return;
        }
    }
}
